package gov.va.vamf.scheduling.varutility.security;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Collection;

public class VoterHelper {
    static boolean hasRole(Collection<? extends GrantedAuthority> authorities, String role) {
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority.getAuthority().equals(role)) {
                return true;
            }
        }
        return false;
    }

    static String getPath(FilterInvocation s) {
        HttpServletRequest httpRequest;
        FilterInvocation fi = s;
        httpRequest = fi.getRequest();

        return httpRequest.getRequestURI();
    }

    static  <S> HttpSession getHttpSession(S s) {
        HttpServletRequest request = ((FilterInvocation) s).getHttpRequest();
        HttpSession session = request.getSession();
        return session;
    }
}
